<?php
require_once "../Api.php";
require "./get/getChannels.php";
require "./put/updateChannels.php";
require "./post/createChannels.php";
require "./patch/changeChannels.php";
require "./delete/deleteChannels.php";

class channelsApi extends Api
{
   public $apiName = "channels";

   /**
    * Метод GET
    * Вывод списка всех записей
    * http://ДОМЕН/Channels
    * @return string
    */
   public function getAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "export":
               return getExpChannels();
               break;
            case "channels":
               return isset($id) ? getChannel($id) : getChannels();
               break;
            case "cameras":
               return getCameras();
               break;
            case "access":
               return getChannelsAccess();
               break;
            case "statistics":
               if (isset($id)) {
                  return getStatistics($id);
               } else {
                  header("HTTP/1.1 400 Bad Request");
                  die();
               }
               break;
            case "signal":
               if (isset($id)) {
                  return getSignal($id);
               } else {
                  header("HTTP/1.1 400 Bad Request");
                  die();
               }
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод POST
    * Создание новой записи
    * http://ДОМЕН/Channels
    * @return string
    */
   public function createAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "channels":
               firstConnection($id);
               break;
            case "config":
               configOnIf($id);
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод PATCH
    * Создание новой записи
    * http://ДОМЕН/Channels
    * @return string
    */
   public function changeAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "channels":
               changeChannelInfo($id);
               break;
            case "title":
               changeChannelName($id);
               break;
            case "contact":
               changeChannelGpio($id);
               break;
            case "state":
               changeState($id);
               break;
            case "timezones":
               changeTimeZones($id);
               break;
            case "multireset":
               multiResetCameras();
               break;
            case "group":
               changeGroup();
               break;
            case "rotate":
               changeRotateImage($id);
               break;
            case "chain":
               changeChainCamera();
               break;
            case "multichannels":
               multiSaveChannels();
               break;
            case "integration":
               changeIntegrationOptions($id);
               break;
            case "integrationMulti":
               changeIntegrationOptionsMulti();
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод PUT
    * Обновление отдельной записи (по ее id)
    * http://ДОМЕН/Channels
    * @return string
    */
   public function updateAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "channels":
               newConnection($id);
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод DELETE
    * Удаление отдельной записи (по ее id)
    * http://ДОМЕН/Channels
    * @return string
    */
   public function deleteAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "channels":
               resetCamera($id);
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }
}
